package com.izenpe.zain.cliente.wss;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaWSS {
	
	private static final String signName = "WS-SecuritySigned.xml";
	
	public static void main(String[] args) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil WSS
			smartVerifyReq.setProfile(Constants.Profile.WSS);
			
			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			/*
			 * True para que la respuesta incluya el formato de la firma (e.g.
			 * BES, ES-T). La invocacin de mtodo es indispensable para
			 * consultar el formato de la respuesta con getSignatureForm.
			 */
			smartVerifyReq.setAddSignatureForm(true);

			// Datos a verificar.
			smartVerifyReq.setInputXmlBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// WSS.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}